/*  optimal cube solver  by  michael reid  reid@math.ucf.edu  */
/*  version 2.1  june 3, 2004  */
/*  symmetry mechanism added  */
/*  malloc.h removed, long string fixed  */

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <setjmp.h>
#include  <signal.h>
#include  <time.h>
#include "unistd.h"
#include "coordinates.txt"

#define N_11                               116280
#define N_12                               116280
#define N_SYM                              32
#define N_TWIST                            16
#define N_11QUOT                           9877
#define N_DIST                             (((N_11QUOT/4)+1)*N_12)
#define TO_BIG                             0
#define MAX_TWISTS                         42
#define  DIST(c, e)     (((e) & 0x1) ? (((e) & 0x2) ? (((int)distance[c][(e)>>2]) >> 6) : ((((int)distance[c][(e)>>2]) & 0xC)>>2)) \
                                     : (((e) & 0x2) ? ((((int)distance[c][(e)>>2]) & 0x30)>>4) : (((int)distance[c][(e)>>2]) & 0x3)))



typedef struct coset_coord
        {
        int             coord12_state;
        int             coord11_state;
        int             sym_state;
        }
        Coset_coord;


typedef struct search_data
        {
        int             depth;
        int             prev_depth;
        int             found;
        int             found_quot;
        }
        Search_data;


typedef struct search_node
        {
        int             remain_depth;
        int             depth_1;
        int             depth_1_bin;
        int             depth_2;
        int             depth_2_bin;
        int             depth_3;
        int             depth_3_bin;
        int             depth_4;
        int             depth_4_bin;
        int             twist;
        int             follow_type;
        Coset_coord     dir_1;
        Coset_coord     dir_2;
        Coset_coord     dir_3;
        Coset_coord     dir_4;
        }
        Search_node;



static unsigned char   *M_table[N_SYM];
static unsigned char   *invsym_on_twist_fb[N_SYM];
static unsigned char   *symmetry_on_twist[N_TWIST];
static unsigned char   *symmetry_on_twist_dir[N_TWIST];
static unsigned int    *selector_11[N_SYM+3];
static unsigned int    *quot11_to_full;
static unsigned short  *twist_x_reduced11_to_sym[N_TWIST];
static unsigned int    *twist_on_reduced11[N_TWIST];
static unsigned int    *twist_on_11[N_TWIST];
static unsigned int    *twist_on_12[N_TWIST];
static char             filename[100];
static unsigned int    *sym_on_11[N_SYM];
static unsigned int    *sym_on_12[N_SYM];
static unsigned short  *twist_on_follow[N_TWIST];
static unsigned short  *follow[N_TWIST];
static unsigned char   *distance[N_12];  

static unsigned long     n_nodes;
static unsigned long     n_tests;
static unsigned long     n_pos;
static int               tm_print;
static int              sol_found;
static int              read_file;
static sigjmp_buf       jump_env;


/* ========================================================================= */
   void  exit_w_error_message(char  *msg)
/* ------------------------------------------------------------------------- */

{
printf("\n%s\n", msg);
exit(EXIT_FAILURE);

return;
}


/* ========================================================================= */
   void  user_interrupt(int  unused_arg)
/* ------------------------------------------------------------------------- */

{
printf("\n-- user interrupt --\n");
fflush(stdout);
siglongjmp(jump_env, 1);

return;
}


/* ========================================================================= */
   void  pretty_print_unsigned_long(unsigned long  nn)
/* ------------------------------------------------------------------------- */

{
int                     digits[7], ii, started;


for (ii = 0; ii < 7; ii++)
    {
    digits[ii] = nn % 1000;
    nn /= 1000;
    }

started = 0;

for (ii = 6; ii >= 0; ii--)
    {
    if (started)
       {
       if (digits[ii] >= 100)
          printf("%3d", digits[ii]);
       else if (digits[ii] >= 10)
               printf("0%2d", digits[ii]);
       else
          printf("00%1d", digits[ii]);
       }
    else
       {
       if (digits[ii] >= 100)
          {
          printf("%3d", digits[ii]);
          started = 1;
          }
       else if (digits[ii] >= 10)
               {
               printf(" %2d", digits[ii]);
               started = 1;
               }
       else if ((digits[ii] >= 1) || (ii == 0))
               {
               printf("  %1d", digits[ii]);
               started = 1;
               }
       else
          printf("   ");
       }

    if (ii > 0)
       printf("%c", started ? ',' : ' ');
    }

return;
}

/* ========================================================================= */
   void  init_M_table(void)
/* ------------------------------------------------------------------------- */

{
unsigned char         (*mem_ptr)[N_SYM];
int                     sym;


/*   allocate and initialize global arrays                                 */


mem_ptr = (unsigned char (*)[N_SYM])
                             malloc(sizeof(unsigned char [N_SYM][N_SYM]));
if (mem_ptr == NULL)
   exit_w_error_message("init_M_table : couldn't get memory");

for (sym = 0; sym < N_SYM; sym++)
    {
    M_table[sym] = mem_ptr[sym];
    }

FILE *f = fopen("M_inv(x)_y.txt", "r") ; // note:  no b since this is a text file
int n=0;
int v ;
while (fscanf(f, "%d", &v) == 1){ 
M_table[n / N_SYM][n % N_SYM] = (unsigned char)(v-1); ;
n++;
}
fclose(f);


return;
}


void init_twist_on_11(void)
{

int sym;


twist_on_11[0] =
          (unsigned int *)malloc(sizeof(unsigned int [N_TWIST][N_11]));
if (twist_on_11[0] == NULL)
   exit_w_error_message("init_twist_on_11 : couldn't get memory");

for (sym = 1; sym < N_TWIST; sym++)
    twist_on_11[sym] = &twist_on_11[0][sym * N_11];
    
printf("Reading 11...\n");    
FILE *f = fopen("mv_11.txt", "r") ; 
int n=0;
int v ;
while (fscanf(f, "%d", &v) == 1){ 
twist_on_11[n / N_11][n % N_11] = v-1; ;
n++;
}
fclose(f);
printf("Finished 11 %1d.\n",n);
return;
}

void init_twist_on_12(void)
{

int sym;


twist_on_12[0] =
          (unsigned int *)malloc(sizeof(unsigned int [N_TWIST][N_12]));
if (twist_on_12[0] == NULL)
   exit_w_error_message("init_twist_on_12 : couldn't get memory");

for (sym = 1; sym < N_TWIST; sym++)
    twist_on_12[sym] = &twist_on_12[0][sym * N_12];
    
printf("Reading 12...\n");    
FILE *f = fopen("mv_12.txt", "r") ; 
int n=0;
int v ;
while (fscanf(f, "%d", &v) == 1){ 
twist_on_12[n / N_12][n % N_12] = v-1; ;
n++;
}
fclose(f);
printf("Finished 12 %1d.\n",n);
return;
}

void init_sym_on_11(void)
{

int sym;


sym_on_11[0] =
          (unsigned int *)malloc(sizeof(unsigned int [N_SYM][N_11]));
if (sym_on_11[0] == NULL)
   exit_w_error_message("init_sym_on_11 : couldn't get memory");

for (sym = 1; sym < N_SYM; sym++)
    sym_on_11[sym] = &sym_on_11[0][sym * N_11];
    
printf("Reading s11...\n");    
FILE *f = fopen("sm_11.txt", "r") ; 
int n=0;
int v ;
while (fscanf(f, "%d", &v) == 1){ 
sym_on_11[n / N_11][n % N_11] = v-1; ;
n++;
}
fclose(f);
printf("Finished s11 %1d.\n",n);
return;
}

void init_sym_on_12(void)
{

int sym;


sym_on_12[0] =
          (unsigned int *)malloc(sizeof(unsigned int [N_SYM][N_12]));
if (sym_on_12[0] == NULL)
   exit_w_error_message("init_sym_on_12 : couldn't get memory");

for (sym = 1; sym < N_SYM; sym++)
    sym_on_12[sym] = &sym_on_12[0][sym * N_12];
    
printf("Reading s12...\n");    
FILE *f = fopen("sm_12.txt", "r") ; 
int n=0;
int v ;
while (fscanf(f, "%d", &v) == 1){ 
sym_on_12[n / N_12][n % N_12] = v-1; ;
n++;
}
fclose(f);
printf("Finished s12 %1d.\n",n);
return;
}


/* ========================================================================= */
   void  init_selector_11(void)
/* ------------------------------------------------------------------------- */

{
int xx,yy,zz,cnt,cnt2,min,sym,var;
int bitvector[N_11];



selector_11[0] =
        (unsigned int *)malloc(sizeof(unsigned int [N_SYM+3][N_11]));
if (selector_11[0] == NULL)
   exit_w_error_message("init_selector_11 : couldn't get memory");

for (sym = 1; sym < N_SYM+3; sym++)
    selector_11[sym] = &selector_11[0][sym * N_11];


for(xx=0;xx<N_11;xx++)
bitvector[xx]=0;              /* punem toate intrarile din bitvector 0 */

cnt=0;

for(xx=0;xx<N_11;xx++){

if(bitvector[xx]==0)

	{
		min=N_11+1;

		for(yy=0;yy<N_SYM;yy++)
		{
			if((int)sym_on_11[yy][xx]<min)
       	 		min=(int)sym_on_11[yy][xx];
 		}


		for(yy=0;yy<N_SYM;yy++)
		{


 			bitvector[(int)sym_on_11[yy][xx]]=1;

 			cnt2=0;
			for(zz=0;zz<N_SYM;zz++)
			{
 				var=(int)sym_on_11[yy][xx];
  				
       
                  if((int)sym_on_11[zz][var]==min)
				{

     					selector_11[cnt2][(int)sym_on_11[yy][xx]]=(unsigned int)zz;
     					cnt2=cnt2+1;

   				}
			}

 				selector_11[N_SYM][(int)sym_on_11[yy][xx]]=(unsigned int)cnt2;
 				selector_11[N_SYM+1][(int)sym_on_11[yy][xx]]=(unsigned int)min;
 				selector_11[N_SYM+2][(int)sym_on_11[yy][xx]]=(unsigned int)cnt;


		}
	cnt=cnt+1; 

	}

}


if(N_11QUOT!=cnt){
printf("Incorrect number of N_11QUOT.\n");
abort();
                    }  
return;
}

void init_quot11_to_full(void)
{
int xx;

 quot11_to_full =
                 (unsigned int *)malloc(sizeof(unsigned int [N_11QUOT]));


if ((quot11_to_full == NULL))
   exit_w_error_message("init_quot11_to_full : couldn't get memory");

for(xx=0;xx<N_11QUOT;xx++)
quot11_to_full[xx]=0;

for(xx=0;xx<N_11;xx++)
quot11_to_full[(int)selector_11[N_SYM+2][xx]]=(unsigned int)selector_11[N_SYM+1][xx];


return;

}


void init_twist_on_reduced11(void)
{

int sym,edge,twist;


twist_on_reduced11[0] =
        (unsigned int *)malloc(sizeof(unsigned int [N_TWIST][N_11QUOT]));
if (twist_on_reduced11[0] == NULL)
   exit_w_error_message("init_twist_on_reduced11 : couldn't get memory");

for (sym = 1; sym < N_TWIST; sym++)
    twist_on_reduced11[sym] = &twist_on_reduced11[0][sym * N_11QUOT];

twist_x_reduced11_to_sym[0] =
        (unsigned short *)malloc(sizeof(unsigned short [N_TWIST][N_11QUOT]));
if (twist_x_reduced11_to_sym[0] == NULL)
   exit_w_error_message("init_twist_on_reduced11 : couldn't get memory");

for (sym = 1; sym < N_TWIST; sym++)
    twist_x_reduced11_to_sym[sym] = &twist_x_reduced11_to_sym[0][sym * N_11QUOT];



    for (edge = 0; edge < N_11QUOT ; edge++)
    for(twist=0;twist<N_TWIST;twist++)
    {
    twist_on_reduced11[twist][edge] =
                                     (unsigned int)selector_11[N_SYM+2][(int)twist_on_11[twist][(int)quot11_to_full[edge]]];
    twist_x_reduced11_to_sym[twist][edge] =
                                     (unsigned short)selector_11[0][(int)twist_on_11[twist][(int)quot11_to_full[edge]]];
    }

return;

}    

/* ========================================================================= */
   void  init_symmetry_on_twist(void)
/* ------------------------------------------------------------------------- */

{
unsigned char         (*mem_ptr)[N_TWIST][N_SYM];
int                     sym;


/*   allocate and initialize global arrays                                 */
/*   symmetry_on_twist   */

mem_ptr = (unsigned char (*)[N_TWIST][N_SYM])
                             malloc(sizeof(unsigned char [N_TWIST][N_SYM]));
if (mem_ptr == NULL)
   exit_w_error_message("init_symmetry_on_twist : couldn't get memory");

for (sym = 0; sym < N_TWIST; sym++)
    {
    symmetry_on_twist[sym] = mem_ptr[0][sym];
    }

FILE *f = fopen("sm_inv_twist.txt", "r") ; // note:  no b since this is a text file
int n=0;
int v ;
while (fscanf(f, "%d", &v) == 1){ 
symmetry_on_twist[n / N_SYM][n % N_SYM] = v-1; ;
n++;
}
fclose(f);

return;
}




/* ========================================================================= */
   void  init_symmetry_on_twist_dir(void)
/* ------------------------------------------------------------------------- */

{
unsigned char         (*mem_ptr)[N_TWIST][4];
int                     sym;


/*   allocate and initialize global arrays                                 */
/*   symmetry_on_twist   */

mem_ptr = (unsigned char (*)[N_TWIST][4])
                             malloc(sizeof(unsigned char [N_TWIST][4]));
if (mem_ptr == NULL)
   exit_w_error_message("init_symmetry_on_twist : couldn't get memory");

for (sym = 0; sym < N_TWIST; sym++)
    {
    symmetry_on_twist_dir[sym] = mem_ptr[0][sym];
    }

FILE *f = fopen("sm_inv_twist_dir.txt", "r") ; // note:  no b since this is a text file
int n=0;
int v ;
while (fscanf(f, "%d", &v) == 1){ 
symmetry_on_twist_dir[n / 4][n % 4] = v-1; ;
n++;
}
fclose(f);

return;
}


/* ========================================================================= */
   void  init_follow(void)
/* ------------------------------------------------------------------------- */

{
unsigned short        (*mem_ptr)[N_FOLLOW];
int                     twist;


mem_ptr = (unsigned short (*)[N_FOLLOW])
                            malloc(sizeof(unsigned short [N_TWIST][N_FOLLOW]));
if (mem_ptr == NULL)
   exit_w_error_message("init_twist_on_follow : couldn't get memory");

for (twist = 0; twist < N_TWIST; twist++)
    follow[twist] = mem_ptr[twist];

FILE *f = fopen("follow.txt", "r") ; // note:  no b since this is a text file
int n=0;
int v ;
while (fscanf(f, "%d", &v) == 1){ 
if (v==-1)
v=N_FOLLOW+1;
follow[n / N_FOLLOW][n % N_FOLLOW] = v-1; ;
n++;
}
fclose(f);


return;
}

int get_distance(int coord_11,int coord_12)
{
int dist,I,J,Ip,Jp,cnt,x,sym;
I=coord_11;
J=coord_12;
dist=DIST(J,I);
cnt=0;
while ( I!=0 || J!=0 ) 
{
	for (x=0;x<16;x++)
		{
        Ip=twist_on_reduced11[x][I];
		sym=twist_x_reduced11_to_sym[x][I];
		Jp=sym_on_12[sym][twist_on_12[x][J]];

		if (dist==0)  
  			if (DIST(Jp,Ip)==2) 
		     break;

		if (dist==2) 
  			if (DIST(Jp,Ip)==1) 
             break;
		
		if (dist==1) 
  			if (DIST(Jp,Ip)==0)  
              break;
		  
        }
	I=Ip;
	J=Jp;
	dist=DIST(Jp,Ip);
	cnt++;
}

return cnt;    


}



/* ========================================================================= */
   int  make_current(int  corner, int  edge, Search_data  *p_data)
/* ------------------------------------------------------------------------- */

{
int elm;

if (DIST(corner, edge) == 3)
   {

 if (edge & 0x1)
      if (edge & 0x2)
         {
         distance[corner][edge >> 2] &= 0x3F;
         distance[corner][edge >> 2] |= (unsigned char)((p_data->depth) << 6);
         }
      else
         {
         distance[corner][edge >> 2] &= 0xF3;
         distance[corner][edge >> 2] |= (unsigned char)((p_data->depth) << 2);
         }
   else
      if (edge & 0x2)
         {
         distance[corner][edge >> 2] &= 0xCF;
         distance[corner][edge >> 2] |= (unsigned char)((p_data->depth) << 4);
         }
      else
         {
         distance[corner][edge >> 2] &= 0xFC;
         distance[corner][edge >> 2] |= (unsigned char)(p_data->depth);
         }
   elm=selector_11[N_SYM][(int)quot11_to_full[edge]];
   if(TO_BIG==0){
   p_data->found = p_data->found+N_SYM / elm;
                }
   p_data->found_quot++;
if((N_SYM % elm) != 0  || elm >N_SYM )
printf("Error in make_current\n");
   return 1;
   }

return 0;
}


/* ========================================================================= */
   void  make_current_all(int  corner, int  edge, Search_data  *p_data)
/* ------------------------------------------------------------------------- */

{
int                     sym, stab,symelement;


if (make_current(corner, edge, p_data))
   {
 
      stab=selector_11[N_SYM][(int)quot11_to_full[edge]];

      for (sym = 0; sym < stab; sym++)
       {
          
          symelement=selector_11[sym][(int)quot11_to_full[edge]]; 
 
          make_current(sym_on_12[symelement][corner],edge,p_data);
       }
   }

return;
}


/* ========================================================================= */
   void  make_neighbors_current(int  corner, int  edge, Search_data  *p_data)
/* ------------------------------------------------------------------------- */

{
int                     twist, new_edge, new_corner, sym;


for (twist = 0; twist < N_TWIST; twist++)
    {


    new_edge = (int)twist_on_reduced11[twist][edge];
    sym = (int)twist_x_reduced11_to_sym[twist][edge];
    new_corner=sym_on_12[sym][(int)twist_on_12[twist][corner]];
   
    make_current_all(new_corner, new_edge, p_data);
    }

return;
}


/* ========================================================================= */
   int  neighbors_are_previous(int  corner, int  edge, Search_data  *p_data)
/* ------------------------------------------------------------------------- */

{
int                 twist, new_edge, sym, new_corner;


for (twist = 0; twist < N_TWIST; twist++)
    {


    new_edge = (int)twist_on_reduced11[twist][edge];
    sym = (int)twist_x_reduced11_to_sym[twist][edge];
    new_corner=sym_on_12[sym][(int)twist_on_12[twist][corner]];
    
    if (DIST(new_corner, new_edge)==p_data->prev_depth)
       return 1;
}

return 0;
}


/* ========================================================================= */
   void  init_distance_table(void)
/* ------------------------------------------------------------------------- */

{
Search_data             sdata_struc;
int                     total_found_quot, corner, edge, ii, msg_given;
int tot[16],jj;

/*  allocate and initialize global array   distance   */

distance[0] = (unsigned char *)malloc(sizeof(unsigned char [N_DIST]));
if (distance[0] == NULL)
   exit_w_error_message("init_distance_table : couldn't get memory");

for (corner = 1; corner < N_12; corner++)
    distance[corner] = &distance[0][corner * ( (N_11QUOT / 4) + 1 )];

read_file=0;

FILE *f = fopen("pruning.dat", "rb") ;

if(f!=NULL){
printf("Reading file...\n");
int r=fread(distance[0],N_DIST, sizeof(*(distance[0])), f) ;
printf("Reading finished.\n");
fclose(f);
read_file=r;
for(ii=0;ii<16;ii++)
tot[ii]=0;
printf("Checking entries...\n");
for (ii = 0; ii < N_12;ii++)
for (jj = 0; jj < N_11QUOT; jj++)
    tot[(int)DIST(ii,jj)]++;;
for(ii=0;ii<16;ii++)
printf("%1d\n",tot[ii]);
}

if(read_file==0)
{

for (ii = 0; ii < N_12; ii++)
    for( jj=0;jj<(N_11QUOT/4)+1;jj++)
    distance[ii][jj] = (unsigned char)255;

msg_given = 0;

sdata_struc.depth = 0;
sdata_struc.found_quot = 0;
sdata_struc.found = 0;
total_found_quot = 0;

printf("distance     positions     (quotient)\n");

make_current(0, 0, &sdata_struc);

while (sdata_struc.found_quot)
      {
      printf("%7dq %13u     (%8d)\n", sdata_struc.depth,
                                                       sdata_struc.found,
                                                       sdata_struc.found_quot);
                   
                                                       
      total_found_quot += sdata_struc.found_quot;
      sdata_struc.found_quot=0;
      sdata_struc.found     =0;

      sdata_struc.depth++;
      sdata_struc.depth=sdata_struc.depth % 3;
      if (sdata_struc.depth==0)
      sdata_struc.prev_depth=2;
      if (sdata_struc.depth==1)
      sdata_struc.prev_depth=0;
      if (sdata_struc.depth==2)
      sdata_struc.prev_depth=1;                            

      if (total_found_quot == N_DIST)
         break;

      if (total_found_quot  > -1  )  /*  search forward  */
         {
         for (corner = 0; corner < N_12; corner++)
             for (edge = 0; edge < N_11QUOT; edge++)
                 if (DIST(corner, edge) == sdata_struc.prev_depth)
                    make_neighbors_current(corner, edge, &sdata_struc);
                                                          
         
         
         }
         
         
         
      else  /*  search backward  */
         {
         if (msg_given == 0)
            {
            printf("     switching to backwards searching\n");
            msg_given = 1;
            }

         for (corner = 0; corner < N_12; corner++)
             for (edge = 0; edge < N_11QUOT; edge++)
                 if ((DIST(corner, edge) == 3) &&
                     neighbors_are_previous(corner, edge, &sdata_struc))
                    make_current(corner, edge, &sdata_struc);
         }
      }




}
return;
}


/* ========================================================================= */
   void  init_globals(void)
/* ------------------------------------------------------------------------- */

{
int xx;
printf("initializing transformation tables\n");
init_follow();
init_twist_on_11();
init_twist_on_12();
init_symmetry_on_twist();
init_symmetry_on_twist_dir();
init_M_table();
init_sym_on_11();
init_sym_on_12();
init_selector_11();
init_quot11_to_full();
init_twist_on_reduced11();
printf("initializing distance table ... this will take several minutes\n");
init_distance_table();
if(read_file==0){
FILE *f = fopen("pruning.dat", "wb") ;
int r=fwrite(distance[0],N_DIST, sizeof(*(distance[0])), f) ;
fclose(f);
printf("%1d\n",r);
}
return;
}



/* ========================================================================= */
   int  user_enters_cube(void)
/* ------------------------------------------------------------------------- */

{
char                     line_str[256];


printf("\nPress any key and enter (Ctrl-D to exit):\n");

line_str[0] = '\n';

while (line_str[0] == '\n')           /*  ignore blank lines  */
      {
      if (fgets(line_str, 256, stdin) == NULL)
         return -1;

      if (line_str[0] == '%')         /*  echo comments  */
         {
         printf("%s", line_str);
         line_str[0] = '\n';
         }
      }

return 0;
}

/* ========================================================================= */
   void  output_solution(Search_node  *node_arr)
/* ------------------------------------------------------------------------- */

{

static char            *twist_string[] = {"aU", "aD", "aL", "aR", "bU", "bD",
                                          "bL", "bR", "cU", "cD", "cL", "cR",
                                          "dU", "dD", "dL", "dR"};
Search_node            *p_node;
int                     turn_list[MAX_TWISTS];
int                     ii, count, q_length, f_length;


count = 0;

for (p_node = node_arr; p_node->remain_depth > 0; p_node++)
    turn_list[count++] = p_node[1].twist;

q_length = f_length = 0;

for (ii = 0; ii < count; ii++)
    {
    q_length += 1;
    f_length += 1;
    }

for (ii = 0; ii < count; ii++)
    printf(" %s", twist_string[turn_list[ii]]);

   printf("  (%dq*, %df)\n", q_length, f_length);
fflush(stdout);

n_tests++;

return;
}





/* ========================================================================= */
   void  search_tree(Search_node  *node_arr)
/* ------------------------------------------------------------------------- */

{
register Search_node   *p_node;
register int            twist, virtual_twist, new_sym_factor,inc;


p_node = node_arr;
while (p_node >= node_arr)
      {
      if (p_node->remain_depth == 0)
         {
         output_solution(node_arr);
         p_node--;
         }
      else
         {
         for (twist = p_node[1].twist + 1; twist < N_TWIST; twist++)
             {
             p_node[1].follow_type =
                              (int)follow[twist][p_node->follow_type];

             if (p_node[1].follow_type == N_FOLLOW)
                continue;

             p_node[1].remain_depth = p_node->remain_depth -
                                         1;
             if (p_node[1].remain_depth < 0)
                continue;

             n_nodes++;



            virtual_twist =
                          (int)symmetry_on_twist[twist][p_node->dir_1.sym_state];
             new_sym_factor =
                (int)twist_x_reduced11_to_sym[virtual_twist][p_node->dir_1.coord11_state];

             p_node[1].dir_1.coord11_state =
                      (int)twist_on_reduced11[virtual_twist][p_node->dir_1.coord11_state];
             p_node[1].dir_1.sym_state =
                (int)M_table[new_sym_factor][p_node->dir_1.sym_state];

             p_node[1].dir_1.coord12_state = (int)sym_on_12[new_sym_factor]
                [(int)twist_on_12[virtual_twist][p_node->dir_1.coord12_state]];


             p_node[1].depth_1_bin=DIST(p_node[1].dir_1.coord12_state, p_node[1].dir_1.coord11_state);
             inc=-1;
             if (p_node[0].depth_1_bin==0 && p_node[1].depth_1_bin==1) 
             inc=1;
             if (p_node[0].depth_1_bin==1 && p_node[1].depth_1_bin==2) 
             inc=1;
			 if (p_node[0].depth_1_bin==2 && p_node[1].depth_1_bin==0) 
             inc=1;
			 if (p_node[0].depth_1_bin==p_node[1].depth_1_bin)
			 inc=0;
			 p_node[1].depth_1=p_node[0].depth_1+inc;

             if (p_node[1].remain_depth <
                      p_node[1].depth_1)
                continue;



            virtual_twist =
                          (int)symmetry_on_twist[symmetry_on_twist_dir[twist][3]][p_node->dir_4.sym_state];
             new_sym_factor =
                (int)twist_x_reduced11_to_sym[virtual_twist][p_node->dir_4.coord11_state];

             p_node[1].dir_4.coord11_state =
                      (int)twist_on_reduced11[virtual_twist][p_node->dir_4.coord11_state];
             p_node[1].dir_4.sym_state =
                (int)M_table[new_sym_factor][p_node->dir_4.sym_state];

             p_node[1].dir_4.coord12_state = (int)sym_on_12[new_sym_factor]
                [(int)twist_on_12[virtual_twist][p_node->dir_4.coord12_state]];


             p_node[1].depth_4_bin=DIST(p_node[1].dir_4.coord12_state, p_node[1].dir_4.coord11_state);
             inc=-1;
             if (p_node[0].depth_4_bin==0 && p_node[1].depth_4_bin==1) 
             inc=1;
             if (p_node[0].depth_4_bin==1 && p_node[1].depth_4_bin==2) 
             inc=1;
			 if (p_node[0].depth_4_bin==2 && p_node[1].depth_4_bin==0) 
             inc=1;
			 if (p_node[0].depth_4_bin==p_node[1].depth_4_bin)
			 inc=0;
			 p_node[1].depth_4=p_node[0].depth_4+inc;

             if (p_node[1].remain_depth <
                      p_node[1].depth_4)
                continue;
                
             if ( ( p_node[1].depth_1==p_node[1].depth_4 ) && ( p_node[1].remain_depth!=0 ) )
              if (p_node[1].remain_depth < p_node[1].depth_4 +1 )
               continue;
               


            virtual_twist =
                          (int)symmetry_on_twist[symmetry_on_twist_dir[twist][1]][p_node->dir_2.sym_state];
             new_sym_factor =
                (int)twist_x_reduced11_to_sym[virtual_twist][p_node->dir_2.coord11_state];

             p_node[1].dir_2.coord11_state =
                      (int)twist_on_reduced11[virtual_twist][p_node->dir_2.coord11_state];
             p_node[1].dir_2.sym_state =
                (int)M_table[new_sym_factor][p_node->dir_2.sym_state];

             p_node[1].dir_2.coord12_state = (int)sym_on_12[new_sym_factor]
                [(int)twist_on_12[virtual_twist][p_node->dir_2.coord12_state]];


             p_node[1].depth_2_bin=DIST(p_node[1].dir_2.coord12_state, p_node[1].dir_2.coord11_state);
             inc=-1;
             if (p_node[0].depth_2_bin==0 && p_node[1].depth_2_bin==1) 
             inc=1;
             if (p_node[0].depth_2_bin==1 && p_node[1].depth_2_bin==2) 
             inc=1;
			 if (p_node[0].depth_2_bin==2 && p_node[1].depth_2_bin==0) 
             inc=1;
			 if (p_node[0].depth_2_bin==p_node[1].depth_2_bin)
			 inc=0;
			 p_node[1].depth_2=p_node[0].depth_2+inc;

             if (p_node[1].remain_depth <
                      p_node[1].depth_2)
                continue;


    virtual_twist =
                          (int)symmetry_on_twist[symmetry_on_twist_dir[twist][2]][p_node->dir_3.sym_state];
             new_sym_factor =
                (int)twist_x_reduced11_to_sym[virtual_twist][p_node->dir_3.coord11_state];

             p_node[1].dir_3.coord11_state =
                      (int)twist_on_reduced11[virtual_twist][p_node->dir_3.coord11_state];
             p_node[1].dir_3.sym_state =
                (int)M_table[new_sym_factor][p_node->dir_3.sym_state];

             p_node[1].dir_3.coord12_state = (int)sym_on_12[new_sym_factor]
                [(int)twist_on_12[virtual_twist][p_node->dir_3.coord12_state]];


             p_node[1].depth_3_bin=DIST(p_node[1].dir_3.coord12_state, p_node[1].dir_3.coord11_state);
             inc=-1;
             if (p_node[0].depth_3_bin==0 && p_node[1].depth_3_bin==1) 
             inc=1;
             if (p_node[0].depth_3_bin==1 && p_node[1].depth_3_bin==2) 
             inc=1;
			 if (p_node[0].depth_3_bin==2 && p_node[1].depth_3_bin==0) 
             inc=1;
			 if (p_node[0].depth_3_bin==p_node[1].depth_3_bin)
			 inc=0;
			 p_node[1].depth_3=p_node[0].depth_3+inc;

             if (p_node[1].remain_depth <
                      p_node[1].depth_3)
                continue;

            if ( ( p_node[1].depth_2==p_node[1].depth_3) && ( p_node[1].remain_depth!=0 ) )
              if (p_node[1].remain_depth < p_node[1].depth_3 +1 )
               continue;




     

             p_node[1].twist = twist;
             break;
             }

         if (twist == N_TWIST)
            p_node--;
         else
            {
            p_node++;
            p_node[1].twist = -1;
            }
         }
      }

return;
}




/* ========================================================================= */
   void  pretty_print_unsigned_int(unsigned int  nn)
/* ------------------------------------------------------------------------- */

{
int                     digits[4], ii, started;


for (ii = 0; ii < 4; ii++)
    {
    digits[ii] = nn % 1000;
    nn /= 1000;
    }

started = 0;

for (ii = 3; ii >= 0; ii--)
    {
    if (started)
       {
       if (digits[ii] >= 100)
          printf("%3d", digits[ii]);
       else if (digits[ii] >= 10)
               printf("0%2d", digits[ii]);
       else
          printf("00%1d", digits[ii]);
       }
    else
       {
       if (digits[ii] >= 100)
          {
          printf("%3d", digits[ii]);
          started = 1;
          }
       else if (digits[ii] >= 10)
               {
               printf(" %2d", digits[ii]);
               started = 1;
               }
       else if ((digits[ii] >= 1) || (ii == 0))
               {
               printf("  %1d", digits[ii]);
               started = 1;
               }
       else
          printf("   ");
       }

    if (ii > 0)
       printf("%c", started ? ',' : ' ');
    }

return;
}


/* ========================================================================= */
   void  solve_cube(void)
/* ------------------------------------------------------------------------- */

{
Search_node             node_arr[MAX_TWISTS];
int                     ii, start_depth, search_limit;
FILE *f;
int r;






node_arr[0].depth_1=get_distance(COORD_11-1,COORD_12-1);
node_arr[0].depth_1_bin=get_distance(COORD_11-1,COORD_12-1) % 3;
node_arr[0].depth_2=get_distance(COORD_21-1,COORD_22-1);
node_arr[0].depth_2_bin=get_distance(COORD_21-1,COORD_22-1) % 3;
node_arr[0].depth_3=get_distance(COORD_31-1,COORD_32-1);
node_arr[0].depth_3_bin=get_distance(COORD_31-1,COORD_32-1) % 3;
node_arr[0].depth_4=get_distance(COORD_41-1,COORD_42-1);
node_arr[0].depth_4_bin=get_distance(COORD_41-1,COORD_42-1) % 3;

node_arr[0].follow_type = FOLLOW_START-1 ;
node_arr[0].dir_1.coord11_state = COORD_11-1;
node_arr[0].dir_1.coord12_state = COORD_12-1;
node_arr[0].dir_1.sym_state = SYM_1-1;

node_arr[0].dir_2.coord11_state = COORD_21-1;
node_arr[0].dir_2.coord12_state = COORD_22-1;
node_arr[0].dir_2.sym_state = SYM_2-1;

node_arr[0].dir_3.coord11_state = COORD_31-1;
node_arr[0].dir_3.coord12_state = COORD_32-1;
node_arr[0].dir_3.sym_state = SYM_3-1;

node_arr[0].dir_4.coord11_state = COORD_41-1;
node_arr[0].dir_4.coord12_state = COORD_42-1;
node_arr[0].dir_4.sym_state = SYM_4-1;


sol_found = 0;
start_depth=0;


   search_limit = MAX_TWISTS - 1;

for (ii = start_depth; ii <= search_limit; ii += 1)
    {
    n_nodes = (unsigned long)0;
    n_tests = (unsigned long)0;
    n_pos = (unsigned long)0;
    node_arr[0].remain_depth = ii;
    node_arr[1].twist = -1;
    search_tree(node_arr);

       printf("depth %2dq completed  (", ii);
       pretty_print_unsigned_long(n_nodes);
       printf(" nodes, ");
       pretty_print_unsigned_long(n_tests);
       printf(" tests, ");
       pretty_print_unsigned_long(n_pos);
       printf(" pos)\n");
       time_t TTT = time(NULL);
       fprintf (stdout, "TIME: %s\n", ctime(&TTT));
       fflush(stdout);
       

    }

return;
}


/* ========================================================================= */
   int  main(void)
/* ------------------------------------------------------------------------- */

{
int                     stat;

init_globals();

signal(SIGINT, SIG_IGN);

while (1)
      {
      stat = user_enters_cube();
      if (stat < 0)
         break;

      if (stat == 0)
         {
         if (sigsetjmp(jump_env, 1) == 0)
            {
            signal(SIGINT, user_interrupt);
            solve_cube();
            }

         signal(SIGINT, SIG_IGN);
         }
      }

exit(EXIT_SUCCESS);

return 0;  /*  haha  */
}
